# 音声合成 Android SDK 開発ドキュメント

**aar依存を追加**

`android-tts-sdk-release-V1.0.0.0.aar` をプロジェクトの `libs` ディレクトリに配置し、`app` モジュールの `build.gradle` を修正して、aarファイルとokhttpを依存関係として追加します。

```java
implementation fileTree(dir:"libs",include:["*.jar","*.aar"])
implementation'com.squareup.okhttp3:okhttp:4.9.0'
 ```

#### アプリ関連の権限を追加

AndroidManifest.xmlファイルを修正します

 ```xml
<!--ネットワーク権限-->
<uses-permission android:name="android.permission.INTERNET" />
```

## 呼び出し手順／サンプルコード

### 1. インスタンスの取得

#### ⑴ 合成クラスを作成

```java
     Tts tts=Tts.getInstance(this,((code,msg)->{
        if("00000".equals(code)){
        System.out.println("Success");
        }else{
        Toast.makeText(this,msg,Toast.LENGTH_SHORT).show();
        }
      }));  
```

#### ⑵ コールバックを設定

（1）コールバックパラメータの説明  
|名前|型|説明|返り値|
|-------|-------|-------|-------|
|onStart|Function|エンジン接続開始時のコールバックメソッド|String型 現在のタスクID|
|onWarning|Function|エンジンが警告を返すコールバックメソッド|タスクIDとErrors型のステータスコード|
|onError|Function|エンジンがエラーを返すコールバックメソッド|タスクIDとErrors型のステータスコード|
|onPlayStart|Function|エンジンが再生開始を通知するコールバックメソッド|なし|
|onPlayFinish|Function|エンジンが合成終了を通知するコールバックメソッド|なし|
|onGetAudio|Function|エンジンが音声データを返すコールバックメソッド|byte[]型の音声データ|
|onSynthesisTimestamp|Function|エンジンがタイムスタンプと音素を返すコールバックメソッド|JsonObject|
|onStop|Function|エンジンが再生終了を通知するコールバックメソッド|なし|

（2）パラメータの例

```java
tts.setListener(new Tts.Listener(){
@Override
public void onStart(String taskId){}

@Override
public void onStop(){}

@Override
public void onError(String taskId,ErrorCodes.ErrorCode err){}

@Override
public void onGetAudio(byte[]data){}

@Override
public void onPlayStart(){}

@Override
public void onPlayFinish(){}

@Override
public void onSynthesisTimestamp(JsonObject payload){}

@Override
public void onWarning(String taskId,ErrorCodes.ErrorCode err){}

        });
```

### 3. パラメータ設定

| **パラメータ**   | タイプ  | **必要かどうか** | **説明**                                                     | デフォルト値                             |
| ---------------- | ------- | ---------------- | ------------------------------------------------------------ | ---------------------------------------- |
| text             | String  | はい             | 合成待ちのテキストの長さの制限は、1024バイト（UTF-8エンコード）です。 | なし                                     |
| lang_type        | String  | はい             | 言語のオプションは、[開発ガイド-言語とボイスのサポート](#/help?url=tts/guidance.md)をご参照ください。 | なし                                     |
| voice            | String  | いいえ           | ボイスのコードは、[開発ガイド-言語とボイスのサポート](#/help?url=tts/guidance.md)をご参照ください。 | 日本語Yuko<br>英語Julie<br>中国語Xiaohui |
| sample_rate      | Integer | いいえ           | 音声のサンプリングレートは、8000、16000、24000を選択できます。 | 24000                                    |
| format           | String  | いいえ           | 音声エンコードの形式、wav / pcm / mp3、<br/> 注意：wav はストリーミングをサポートしていません。 | pcm                                      |
| speech_rate      | Float   | いいえ           | 話速、パラメータ範囲 [0.2, 3]、通常は小数点以下1桁で十分です | 1                                        |
| volume           | Float   | いいえ           | 音量、パラメータ範囲 [0.1, 3]、通常は小数点以下1桁で十分です | 1                                        |
| pitch_rate       | Float   | いいえ           | イントネーション、パラメータ範囲[0.1, 3]、通常は小数点以下1桁で十分です | 1                                        |
| emotion          | String  | いいえ           | 感情・スタイル、[開発ガイド-言語とボイスのサポート](#/help?url=tts/guidance.md) を参照してください。 | なし                                     |
| silence_duration | Integer | いいえ           | 文末の無音時間、単位はミリ秒（ms）です                       | 125                                      |
| enable_timestamp | Boolean | いいえ           | タイムスタンプ関連、trueを渡すと有効になり、元のテキストのタイムスタンプを返すことができます。注意：元のテキストに連続した句読点やスペースは依然として処理されますが、タイムスタンプの連続性には影響しません。 | false                                    |


```java
   Tts.Params params=tts.getParams();
        params.setText(text);
        params.setSampleRate(24000);
        params.setFormat("pcm");
        params.setLang("ja-JP");
```

### 4. 合成の開始／停止

```java
tts.start();
tts.stop(); 
```